﻿using System;
using System.Threading.Tasks;
using AuthChecker;
using MediatR;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using QualityManagement.MediatR;

namespace QualityManagement.API.Controllers.Risk_Management
{
    /// <summary>
    /// Controller for RiskCategory
    /// </summary>
    [Route("api/[controller]")]
    [ApiController]
    [Authorize]
    public class RiskCategoryController(IMediator _mediator) : BaseController
    {
        /// <summary>
        /// Create a risk Category
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [ClaimCheck("ADD_RISK_CATEGORY")]
        public async Task<IActionResult> CreateRiskCategory(AddRiskCategoryCommand command)
        {
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        /// Delete Risk Category
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpDelete("{id}")]
        [ClaimCheck("DELETE_RISK_CATEGORY")]
        public async Task<IActionResult> DeleteRiskCategory(Guid id)
        {
            var result = await _mediator.Send(new DeleteRiskCategoryCommand() { Id = id });
            return GenerateResponse(result);
        }

        /// <summary>
        /// Update RiskCategory by RiskCategory Id
        /// </summary>
        /// <param name="id"></param>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut("{id}")]
        [ClaimCheck("EDIT_RISK_CATEGORY")]
        public async Task<IActionResult> UpdateRiskCategory(Guid id, UpdateRiskCategoryCommand command)
        {
            command.Id = id;
            var result = await _mediator.Send(command);
            return GenerateResponse(result);
        }

        /// <summary>
        /// get All riskCategories
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [ClaimCheck("VIEW_RISK_CATEGORY")]
        public async Task<IActionResult> GetAllRiskCategory()
        {
            var result = await _mediator.Send(new GetAllRiskCategoryCommand());
            return GenerateResponse(result);
        }
    }
}
